package mole 
{
	import mole.state.CMenu;
	import mole.state.IState;
	import flash.geom.Point;
	/**
	 * Gestionnaire des états du jeu.
	 * @author Cédric Liaudet
	 */
	public class CGameStateManager 
	{
		/**
		 * Constructeur.
		 */
		public function CGameStateManager() 
		{
			m_CurrentState = new CMenu;
			m_CurrentState.OnStart();
			
			m_aPausedState = new Vector.<IState>();
		}
		
		/**
		 * Mise à jours de l'état courant.
		 */
		public function OnUpdate():void
		{
			if (m_CurrentState)
				m_CurrentState.OnUpdate();
		}
		
		/**
		 * Suppression du menu courant.
		 */
		public function RemoveCurrentState():void
		{
			if (m_CurrentState)
				m_CurrentState.OnEnd();
				
			// On restaure l'état sur le haut de la pile.
			if (m_aPausedState.length)
			{
				m_CurrentState = m_aPausedState.pop();
				m_CurrentState.OnResume();
			}
			else
				m_CurrentState = null;
		}
		
		/**
		 * Définie le nouvel état courant.
		 */
		public function SetCurrentState(_NewState:IState, _bRemoveCurrent:Boolean = true):void
		{
			if (_NewState != null)
			{
				if (m_CurrentState)
				{
					if (_bRemoveCurrent)
						RemoveCurrentState();
					else
					{
						m_CurrentState.OnPause();
						m_aPausedState.push(m_CurrentState);
					}
				}				
					
				m_CurrentState = _NewState;
				m_CurrentState.OnStart();
			}
		}
		
		private var m_CurrentState:IState; 			///< L'état courant.
		private var m_aPausedState:Vector.<IState>;	///< La pile d'état.
	}

}